C
C ====================================================================
C ========================= T E N S O R ==============================
C ====================================================================
C
      SUBROUTINE TENSOR(ELEM_TYPE,VECT,TENS,FACT)
C
C ====================================================================
C I                                                                  I
C I     THIS PROGRAM CALCULATES MATRICES WHICH ARE COMMON IN         I
C I     MOST OF THE SUBROUTINES THAT CONSTITUTE THE PLASTICITY       I
C I     FORMULATIONS.                                                I
C I                                                                  I
C I       VECT( I )   = VECTOR TO BE CONVERTED TO A TENSOR           I
C I       TENS(I , J) = TENSOR EQUIVALENT OF VECT(I)                 I
C I                                                                  I
C ====================================================================
C
      IMPLICIT NONE
      REAL*8 VECT(6),TENS(3,3),FACT
      INTEGER ELEM_TYPE
C
      CALL DIARRAY(TENS,3,3,0,0,0,0,0)
      TENS(1 , 1) = VECT( 1 )
      TENS(2 , 2) = VECT( 2 )
      IF (ELEM_TYPE.LT.300) THEN
        TENS(3 , 3) = VECT( 4 )
        TENS(1 , 2) = VECT( 3 )*FACT
        TENS(2 , 1) = TENS(1 , 2)
      ELSE
        TENS(3 , 3) = VECT( 3 )
        TENS(1 , 2) = VECT( 4 )*FACT
        TENS(2 , 1) = TENS(1 , 2)
        TENS(1 , 3) = VECT( 6 )*FACT
        TENS(3 , 1) = TENS(1 , 3)
        TENS(2 , 3) = VECT( 5 )*FACT
        TENS(3 , 2) = TENS(2 , 3)
      END IF
C
      END
C
C ====================================================================
C ========================= V E C T O R ==============================
C ====================================================================
C
      SUBROUTINE VECTOR(ELEM_TYPE,TENS,VECT,FACT)
C
C ====================================================================
C I                                                                  I
C I     THIS PROGRAM CALCULATES MATRICES WHICH ARE COMMON IN         I
C I     MOST OF THE SUBROUTINES THAT CONSTITUTE THE PLASTICITY       I
C I     FORMULATIONS.                                                I
C I                                                                  I
C I       TENS(I , J) = TENSOR TO BE CONVERTED TO A VECTOR           I
C I       VECT( I )   = VECTOR EQUIVALENT OT TENS(I , J)             I
C I                                                                  I
C ====================================================================
C
      IMPLICIT NONE
      REAL*8 VECT(6),TENS(3,3),FACT
      INTEGER ELEM_TYPE
C
      CALL DIARRAY(VECT,6,0,0,0,0,0,0)
      VECT( 1 ) = TENS(1 , 1)
      VECT( 2 ) = TENS(2 , 2)
      IF (ELEM_TYPE.LT.300) THEN
        VECT( 4 ) = TENS(3 , 3)
        VECT( 3 ) = TENS(1 , 2)*FACT
      ELSE
        VECT( 3 ) = TENS(3 , 3)
        VECT( 4 ) = TENS(1 , 2)*FACT
        VECT( 6 ) = TENS(1 , 3)*FACT
        VECT( 5 ) = TENS(2 , 3)*FACT
      END IF
C
      END
C
C =====================================================================
C ========================= C O N V E R ===============================
C =====================================================================
C
      SUBROUTINE CONVER(D4,D2,STRS_STRN_REL,ELEM_TYPE)
C
C ====================================================================
C I                                                                  I
C I        THIS PROGRAM TRANSFORMS THE FOURTH ORDER STIFFNESS        I
C I        TENSOR TO A SECOND ORDER MATRIX                           I
C I                                                                  I
C ====================================================================
C
      IMPLICIT NONE
      INTEGER STRS_STRN_REL,PLANE_STRESS
      PARAMETER (PLANE_STRESS=1)
      INTEGER ELEM_TYPE,K1
      REAL*8 D4(3,3,3,3),D2(6,6),CST1,CST2,CST3,ZERO,TWO
C
      DATA ZERO,TWO /0.0D0,2.0D0/
C
C     D2 = THE SECOND ORDER STIFFNESS MATRIX
C
      CALL DIARRAY(D2,6,6,0,0,0,0,0)
      IF (ELEM_TYPE.LT.300) THEN
        D2(1,1) = D4(1,1,1,1)
        D2(1,2) = D4(1,1,2,2)
        D2(1,3) = D4(1,1,1,2)
        D2(1,4) = D4(1,1,3,3)
        D2(2,1) = D4(2,2,1,1)
        D2(2,2) = D4(2,2,2,2)
        D2(2,3) = D4(2,2,1,2)
        D2(2,4) = D4(2,2,3,3)
        D2(3,1) = D4(1,2,1,1)
        D2(3,2) = D4(1,2,2,2)
        D2(3,3) = D4(1,2,1,2)
        D2(3,4) = D4(1,2,3,3)
        D2(4,1) = D4(3,3,1,1)
        D2(4,2) = D4(3,3,2,2)
        D2(4,3) = D4(3,3,1,2)
        D2(4,4) = D4(3,3,3,3)
        IF(STRS_STRN_REL.NE.PLANE_STRESS) RETURN
        CST1 = D4(3,3,1,1)/D4(3,3,3,3)
        CST2 = D4(3,3,2,2)/D4(3,3,3,3)
        CST3 = (D4(3,3,1,2)+D4(3,3,2,1))/D4(3,3,3,3)/TWO
        D2(1,1) = D2(1,1)-CST1*D4(1,1,3,3)
        D2(1,2) = D2(1,2)-CST2*D4(1,1,3,3)
        D2(1,3) = D2(1,3)-CST3*D4(1,1,3,3)
        D2(2,1) = D2(2,1)-CST1*D4(2,2,3,3)
        D2(2,2) = D2(2,2)-CST2*D4(2,2,3,3)
        D2(2,3) = D2(2,3)-CST3*D4(2,2,3,3)
        D2(3,1) = D2(3,1)-CST1*D4(1,2,3,3)
        D2(3,2) = D2(3,2)-CST2*D4(1,2,3,3)
        D2(3,3) = D2(3,3)-CST3*D4(1,2,3,3)
        DO K1=1,4
          D2(4,K1)=ZERO
          D2(K1,4)=ZERO
        END DO
      ELSE
        CALL DTENSOR_TO_MATRIX_FULL(D4,D2)
      END IF
C
      END
